<?php

namespace App\Exports\Billar;

use App\Models\Billar\Invoice\Invoice;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ClientStatementExport implements FromCollection, WithHeadings
{
    public function headings(): array
    {
        return [
            __t('date'),
            __t('activity'),
            __t('invoice_number'),
            __t('client'),
            __t('payment'),
            __t('balance'),
        ];
    }

    public function collection()
    {
        $data = Invoice::query()->get();

        return $data->map(function ($row) {
            return [
                'date' => $row->date,
                'activity' => $row->received_amount ? __t('payment_received') : __t('invoice_generated'),
                'invoice_number' => $row->invoice_number,
                'client' => $row->client->full_name,
                'payment' => $row->received_amount ? $row->received_amount : '0',
                'balance' => $row->due_amount ? $row->due_amount : '0',
            ];
        });
    }
}
