<?php


namespace App\Http\Requests\App;


use App\Models\App\Traits\SmsDriverValidationRules;

class SmsValidationRequest extends AppRequest
{
    use SmsDriverValidationRules;

    public function rules()
    {
        $driver = request()->only('sms_driver');

        switch ($driver['sms_driver']) {
            case 'nexmo':
                return $this->nexmoRules();
                break;
            case 'twilio':
                return $this->twilioRules();
                break;
            default:
                return $this->twilioRules();
        }
    }
}