<?php

namespace App\Mail\Billar;

use App\Mail\Tag\InvoiceTag;
use App\Mail\Tag\NewInvoiceTag;
use App\Notifications\Core\Helper\NotificationTemplateHelper;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use PDF;

class NewInvoiceGenerateMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $invoice;
    protected $reciever;

    protected string $template;

    protected $pdf;

    public function __construct($invoice, $pdf,$reciever)
    {
        $tag = new NewInvoiceTag($invoice,auth()->user(),$reciever);

        $this->invoice = $invoice;
        $this->reciever = $reciever;

        $template = $this->template();

        $this->pdf = $pdf;

        $this->template = optional($template)->parse(
            method_exists($tag, 'invoiceGenerate') ? $tag->invoiceGenerate() : ['{invoice_number}' => optional($this->invoice)->invoice_number]
        );

        $this->subject = optional($template)->parseSubject(
            method_exists($tag, 'invoiceGenerate') ? $tag->invoiceGenerate() : ['{invoice_number}' => optional($this->invoice)->invoice_number]
        );

    }


    public function build()
    {
        return $this->view('notification.mail.user.template', [
            'template' => $this->template
        ])->subject($this->subject)
            ->attach(storage_path('app/public/pdf/invoice_recurring_' . $this->invoice->id . '.pdf'), [
                'as' => 'invoice.pdf',
                'mime' => 'application/pdf',
            ]);
    }

    public function template()
    {
        return NotificationTemplateHelper::new()
            ->on('new_invoice_generate')
            ->mail();
    }
}
