<?php

namespace App\Mail\Tag;

use App\Helpers\App\Traits\DateFormatTrait;

class NewInvoiceTag extends Tag
{
    use DateFormatTrait;

    protected object $invoice;
    protected $receiver;

    public function __construct($invoice,$notifier,$receiver)
    {
        $this->invoice = $invoice;
        $this->notifier = $notifier;
        $this->receiver = $receiver;
    }

    public function invoiceGenerate(): array
    {
        return $this->notification();
    }

    public function notification(): array
    {
        return array_merge([
            '{receiver_name}' => $this->receiver->full_name,
            '{invoice_number}' => $this->invoice->invoice_number,
            '{date}' => $this->dateFormat($this->invoice->due_date),
        ], $this->appNameAndLogo());
    }
}